// firstly we need a reference to the Game Window.
var win = Titanium.UI.currentWindow;

// create a View to use for a BG, we could have set this in the app.js but
// as it's relevent to this piece of functionality we set it here
var viewBG = Titanium.UI.createView({
	width: '100%',
	height: '100%',
	backgroundImage: './iphone/iDefuse_gamebg.png'
});

// explosion View, we use this to show which bomb has blown up
// note this is initially hidden above the screen by setting top: -300
var viewExplosion = Titanium.UI.createView({
	width: 185,
	height: 185,
	top: -300,
	backgroundImage: './iphone/iDefuse_boom.png'
});

// add the bg View and the Explosion View to the Game Window
win.add(viewBG);
win.add(viewExplosion);



// here are some game related variables
var defused = 0; 	// score
var loopTimer;		// a timer used as a game loop
var bombArray = [];	// will hold a reference to all bombs
var inGame;			// a Boolean that tracks if the game is playing (true) or not (false)


// this method is used to create a bomb of a random type (pink, blue or black).
// it also attaches Event Listeners to the bomb for dragging and clicking.
function createBomb() {
	
	// determine a random type for this bomb
	var type = Math.ceil(Math.random() * 3);
	
	// a bomb is made of two parts, the image of the bomb which is created below using a View
	var img = Titanium.UI.createView({
		width: 58,
		height: 68,
		// position randomly
		top: (Math.random() * 640),
		left: (Math.random() * 850) + 60,
		// create the image from the type
		backgroundImage: './iphone/iDefuse_bombType' + type + '.png'
	});
	
	// add the bomb View to our Game Window
	win.add(img);
	
	// the second part of the bomb is this bomb object
	// we store the type, amount of clicks it has received,
	// the View and it's current time inside it as properties
	var bomb = {
		type: type,
		clicks: 0,
		view: img,
		live: true,
		seconds: 5
	};
	
	// attach Event Listener so that when the View is dragged it updates it's position and checks if it's near the left or right edge
	if(type == 1 || type == 2) {
		bomb.view.addEventListener('touchmove', function(e) {
			bomb.view.left = e.x - 25;
			bomb.view.top = e.y - 30;
		
			// if pink bomb is over the right side of the screen
			if(bomb.type == 1 && bomb.view.left > 985)
			{
				// in which case remove the bomb and increase the score
				win.remove(bomb.view);
				defused++;
				bomb.live = false;
			}
		
			// if blue bomb is over the left side of the screen
			if(bomb.type == 2 && bomb.view.left < 10)
			{
				// in which case remove the bomb and increase the score
				win.remove(bomb.view);
				defused++;
				bomb.live = false;
			}
		});
	}
	
	// attach another Event Listener if type is 3 (black bomb) to count
	// the amount of time the bomb is clicked
	if(type == 3) {
		bomb.view.addEventListener('touchstart', function(e) {
			bomb.clicks++;
			
			// defuse on three clicks
			if(bomb.clicks > 2)
			{
				win.remove(bomb.view);
				defused++;
				bomb.live = false;
			}
		});
	}
	
	// keep a reference to the bomb in an Array for clearing the Game Window on restart Game
	bombArray.push(bomb);
	
	// return the instance of the bomb
	return bomb;
}


// the game loop
function mainLoop(e) {
	
	// each loop ( 1.5 sec) create a new bomb, update the current bombs
	if(inGame == true)
	{
		var bomb = createBomb();
		
		// update each bomb
		for(var i = 0; i < bombArray.length; i++)
		{
			if(bombArray[i].live == true)
			{
				bombArray[i].seconds--;
				bombArray[i].view.backgroundImage = './iphone/iDefuse_bombType' + bombArray[i].type + '_' + bombArray[i].seconds + '.png';

				// test for detonation
				if(bombArray[i].seconds == 0)
				{
					viewExplosion.top = bombArray[i].view.top - 52;
					viewExplosion.left = bombArray[i].view.left - 60;
					
					// end of game
					this.endGame();
				}
			}
		}
	}
}

// begins the game
function beginGame() {
	defused = 0;
	inGame = true;
	
	// triggers the main game loop every 1000ms
	loopTimer = setInterval(mainLoop, 1500);
	
	// clean screen (for game restarts)
	for(var i = 0; i < bombArray.length; i++)
	{
		if(bombArray[i].live == true)
		{
			win.remove(bombArray[i].view);
		}
	}
	bombArray = [];
	viewExplosion.top = -300;
}

// clears the data
function endGame() {
	clearInterval(loopTimer);
	inGame = false;
	
	// show an alert to the user
	var alertDialog = Titanium.UI.createAlertDialog({
	    title: 'Game Over',
	    message: 'You defused ' + defused + ' bombs!',
	    buttonNames: ['Play Again','Back (Boo!)']
	});
	
	alertDialog.addEventListener('click', function (e) {
		// if the user pressed the play again button
		if(e.index == 0)
		{
			beginGame();
		} else
		{
			// otherwise close the Game Window
			win.close();
		}
	});
	alertDialog.show();
	
}

// begin the game when this Window is opened
win.onfocus = this.beginGame();
